"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, name: str, version: str, client_request_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster continues to function during the update. The response output includes an update ID that you can use to track the status of your cluster update with the DescribeUpdate API operation. Cluster updates are asynchronous, and they should finish within a few minutes. During an update, the cluster status moves to UPDATING (this status transition is eventually consistent). When the update is complete (either Failed or Successful), the cluster status moves to Active. If your cluster has managed node groups attached to it, all of your node groups’ Kubernetes versions must match the cluster’s Kubernetes version in order to update the cluster to a new Kubernetes version.

    Args:
        name(str): The name of the Amazon EKS cluster to update.
        version(str): The desired Kubernetes version following a successful update.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.cluster.version.update(ctx, name=value, version=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.cluster.version.update name=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="update_cluster_version",
        op_kwargs={
            "name": name,
            "version": version,
            "clientRequestToken": client_request_token,
        },
    )
