"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    role_arn: str,
    resources_vpc_config: Dict,
    version: str = None,
    kubernetes_network_config: Dict = None,
    logging: Dict = None,
    client_request_token: str = None,
    tags: Dict = None,
    encryption_config: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon EKS control plane.  The Amazon EKS control plane consists of control plane instances that run the Kubernetes software, such as etcd and the API server. The control plane runs in an account managed by Amazon Web Services, and the Kubernetes API is exposed via the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane is single-tenant and unique and runs on its own set of Amazon EC2 instances. The cluster control plane is provisioned across multiple Availability Zones and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS also provisions elastic network interfaces in your VPC subnets to provide connectivity from the control plane instances to the nodes (for example, to support kubectl exec, logs, and proxy data flows). Amazon EKS nodes run in your Amazon Web Services account and connect to your cluster's control plane via the Kubernetes API server endpoint and a certificate file that is created for your cluster. Cluster creation typically takes several minutes. After you create an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate with the API server and launch nodes into your cluster. For more information, see Managing Cluster Authentication and Launching Amazon EKS nodes in the Amazon EKS User Guide.

    Args:
        name(str): The unique name to give to your cluster.
        version(str, optional): The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version available in Amazon EKS is used. Defaults to None.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see Amazon EKS Service IAM Role in the  Amazon EKS User Guide .
        resources_vpc_config(Dict): The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see Cluster VPC Considerations and Cluster Security Group Considerations in the Amazon EKS User Guide. You must specify at least two subnets. You can specify up to five security groups, but we recommend that you use a dedicated security group for your cluster control plane.
        kubernetes_network_config(Dict, optional): The Kubernetes network configuration for the cluster. Defaults to None.
        logging(Dict, optional): Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see Amazon EKS Cluster control plane logs in the  Amazon EKS User Guide .  CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see CloudWatch Pricing. . Defaults to None.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        tags(Dict, optional): The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Defaults to None.
        encryption_config(List, optional): The encryption configuration for the cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.cluster.init.create(
                ctx, name=value, role_arn=value, resources_vpc_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.cluster.init.create name=value, role_arn=value, resources_vpc_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="create_cluster",
        op_kwargs={
            "name": name,
            "version": version,
            "roleArn": role_arn,
            "resourcesVpcConfig": resources_vpc_config,
            "kubernetesNetworkConfig": kubernetes_network_config,
            "logging": logging,
            "clientRequestToken": client_request_token,
            "tags": tags,
            "encryptionConfig": encryption_config,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the Amazon EKS cluster control plane. If you have active services in your cluster that are associated with a load balancer, you must delete those services before deleting the cluster so that the load balancers are deleted properly. Otherwise, you can have orphaned resources in your VPC that prevent you from being able to delete the VPC. For more information, see Deleting a Cluster in the Amazon EKS User Guide. If you have managed node groups or Fargate profiles attached to the cluster, you must delete them first. For more information, see DeleteNodegroup and DeleteFargateProfile.

    Args:
        name(str): The name of the cluster to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.cluster.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.cluster.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="eks", operation="delete_cluster", op_kwargs={"name": name}
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns descriptive information about an Amazon EKS cluster. The API server endpoint and certificate authority data returned by this operation are required for kubelet and kubectl to communicate with your Kubernetes API server. For more information, see Create a kubeconfig for Amazon EKS.  The API server endpoint and certificate authority data aren't available until the cluster reaches the ACTIVE state.

    Args:
        name(str): The name of the cluster to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.cluster.init.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.cluster.init.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="eks", operation="describe_cluster", op_kwargs={"name": name}
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Amazon EKS clusters in your Amazon Web Services account in the specified Region.

    Args:
        max_results(int, optional): The maximum number of cluster results returned by ListClusters in paginated output. When you use this parameter, ListClusters returns only maxResults results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListClusters request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListClusters returns up to 100 results and a nextToken value if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListClusters request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.  This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.cluster.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.cluster.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="list_clusters",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
