"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    kubernetes_version: str = None,
    max_results: int = None,
    next_token: str = None,
    addon_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the Kubernetes versions that the add-on can be used with.

    Args:
        kubernetes_version(str, optional): The Kubernetes versions that the add-on can be used with. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeAddonVersionsRequest where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.  This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        addon_name(str, optional): The name of the add-on. The name must match one of the names returned by  ListAddons . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.addon.version.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.addon.version.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="describe_addon_versions",
        op_kwargs={
            "kubernetesVersion": kubernetes_version,
            "maxResults": max_results,
            "nextToken": next_token,
            "addonName": addon_name,
        },
    )
