"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    cluster_name: str,
    addon_name: str,
    addon_version: str = None,
    service_account_role_arn: str = None,
    resolve_conflicts: str = None,
    client_request_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon EKS add-on. Amazon EKS add-ons help to automate the provisioning and lifecycle management of common operational software for Amazon EKS clusters. Amazon EKS add-ons can only be used with Amazon EKS clusters running version 1.18 with platform version eks.3 or later because add-ons rely on the Server-side Apply Kubernetes feature, which is only available in Kubernetes 1.18 and later.

    Args:
        cluster_name(str): The name of the cluster to create the add-on for.
        addon_name(str): The name of the add-on. The name must match one of the names returned by  DescribeAddonVersions .
        addon_version(str, optional): The version of the add-on. The version must match one of the versions returned by  DescribeAddonVersions . Defaults to None.
        service_account_role_arn(str, optional): The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see Amazon EKS node IAM role in the Amazon EKS User Guide.  To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see Enabling IAM roles for service accounts on your cluster in the Amazon EKS User Guide. . Defaults to None.
        resolve_conflicts(str, optional): How to resolve parameter value conflicts when migrating an existing add-on to an Amazon EKS add-on. Defaults to None.
        client_request_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        tags(Dict, optional): The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.addon.init.create(ctx, cluster_name=value, addon_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.addon.init.create cluster_name=value, addon_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="create_addon",
        op_kwargs={
            "clusterName": cluster_name,
            "addonName": addon_name,
            "addonVersion": addon_version,
            "serviceAccountRoleArn": service_account_role_arn,
            "resolveConflicts": resolve_conflicts,
            "clientRequestToken": client_request_token,
            "tags": tags,
        },
    )


async def delete(hub, ctx, cluster_name: str, addon_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an Amazon EKS add-on. When you remove the add-on, it will also be deleted from the cluster. You can always manually start an add-on on the cluster using the Kubernetes API.

    Args:
        cluster_name(str): The name of the cluster to delete the add-on from.
        addon_name(str): The name of the add-on. The name must match one of the names returned by  ListAddons .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.addon.init.delete(ctx, cluster_name=value, addon_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.addon.init.delete cluster_name=value, addon_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="delete_addon",
        op_kwargs={"clusterName": cluster_name, "addonName": addon_name},
    )


async def describe(hub, ctx, cluster_name: str, addon_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an Amazon EKS add-on.

    Args:
        cluster_name(str): The name of the cluster.
        addon_name(str): The name of the add-on. The name must match one of the names returned by  ListAddons .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.addon.init.describe(
                ctx, cluster_name=value, addon_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.addon.init.describe cluster_name=value, addon_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="describe_addon",
        op_kwargs={"clusterName": cluster_name, "addonName": addon_name},
    )


async def list_all(
    hub, ctx, cluster_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the available add-ons.

    Args:
        cluster_name(str): The name of the cluster.
        max_results(int, optional): The maximum number of add-on results returned by ListAddonsRequest in paginated output. When you use this parameter, ListAddonsRequest returns only maxResults results in a single page along with a nextToken response element. You can see the remaining results of the initial request by sending another ListAddonsRequest request with the returned nextToken value. This value can be between 1 and 100. If you don't use this parameter, ListAddonsRequest returns up to 100 results and a nextToken value, if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListAddonsRequest where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.  This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.addon.init.list_all(ctx, cluster_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.addon.init.list_all cluster_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="list_addons",
        op_kwargs={
            "clusterName": cluster_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    cluster_name: str,
    addon_name: str,
    addon_version: str = None,
    service_account_role_arn: str = None,
    resolve_conflicts: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Amazon EKS add-on.

    Args:
        cluster_name(str): The name of the cluster.
        addon_name(str): The name of the add-on. The name must match one of the names returned by  ListAddons .
        addon_version(str, optional): The version of the add-on. The version must match one of the versions returned by  DescribeAddonVersions . Defaults to None.
        service_account_role_arn(str, optional): The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role. For more information, see Amazon EKS node IAM role in the Amazon EKS User Guide.  To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see Enabling IAM roles for service accounts on your cluster in the Amazon EKS User Guide. . Defaults to None.
        resolve_conflicts(str, optional): How to resolve parameter value conflicts when applying the new version of the add-on to the cluster. Defaults to None.
        client_request_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.eks.addon.init.update(ctx, cluster_name=value, addon_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.eks.addon.init.update cluster_name=value, addon_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="eks",
        operation="update_addon",
        op_kwargs={
            "clusterName": cluster_name,
            "addonName": addon_name,
            "addonVersion": addon_version,
            "serviceAccountRoleArn": service_account_role_arn,
            "resolveConflicts": resolve_conflicts,
            "clientRequestToken": client_request_token,
        },
    )
