"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, file_system_id: str, tags: List) -> None:
    r"""
    **Autogenerated function**

     DEPRECATED - CreateTags is deprecated and not maintained. Please use the API action to create tags for EFS resources.  Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If a tag key specified in the request already exists on the file system, this operation overwrites its value with the value provided in the request. If you add the Name tag to your file system, Amazon EFS returns it in the response to the DescribeFileSystems operation.  This operation requires permission for the elasticfilesystem:CreateTags action.

    Args:
        file_system_id(str): The ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not the file system.
        tags(List): An array of Tag objects to add. Each Tag object is a key-value pair. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.tags.init.create(ctx, file_system_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.tags.init.create file_system_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="create_tags",
        op_kwargs={"FileSystemId": file_system_id, "Tags": tags},
    )


async def delete(hub, ctx, file_system_id: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

     DEPRECATED - DeleteTags is deprecated and not maintained. Please use the API action to remove tags from EFS resources.  Deletes the specified tags from a file system. If the DeleteTags request includes a tag key that doesn't exist, Amazon EFS ignores it and doesn't cause an error. For more information about tags and related restrictions, see Tag Restrictions in the AWS Billing and Cost Management User Guide. This operation requires permissions for the elasticfilesystem:DeleteTags action.

    Args:
        file_system_id(str): The ID of the file system whose tags you want to delete (String).
        tag_keys(List): A list of tag keys to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.tags.init.delete(ctx, file_system_id=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.tags.init.delete file_system_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="delete_tags",
        op_kwargs={"FileSystemId": file_system_id, "TagKeys": tag_keys},
    )


async def describe(
    hub, ctx, file_system_id: str, max_items: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     DEPRECATED - The DeleteTags action is deprecated and not maintained. Please use the API action to remove tags from EFS resources.  Returns the tags associated with a file system. The order of tags returned in the response of one DescribeTags call and the order of tags returned across the responses of a multiple-call iteration (when using pagination) is unspecified.   This operation requires permissions for the elasticfilesystem:DescribeTags action.

    Args:
        max_items(int, optional): (Optional) The maximum number of file system tags to return in the response. Currently, this number is automatically set to 100, and other values are ignored. The response is paginated at 100 per page if you have more than 100 tags. Defaults to None.
        marker(str, optional): (Optional) An opaque pagination token returned from a previous DescribeTags operation (String). If present, it specifies to continue the list from where the previous call left off. Defaults to None.
        file_system_id(str): The ID of the file system whose tag set you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.tags.init.describe(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.tags.init.describe file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_tags",
        op_kwargs={
            "MaxItems": max_items,
            "Marker": marker,
            "FileSystemId": file_system_id,
        },
    )
