"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve the tags for. This operation requires permissions for the elasticfilesystem:DescribeAccessPoints action.

    Args:
        resource_id(str): Specifies the EFS resource you want to retrieve tags for. You can retrieve tags for EFS file systems and access points using this API endpoint.
        max_results(int, optional): (Optional) Specifies the maximum number of tag objects to return in the response. The default value is 100. Defaults to None.
        next_token(str, optional): (Optional) You can use NextToken in a subsequent request to fetch the next page of access point descriptions if the response payload was paginated. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.tags.for_resource.list(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.tags.for_resource.list resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="list_tags_for_resource",
        op_kwargs={
            "ResourceId": resource_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
