"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def tag(hub, ctx, resource_id: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API operation. This operation requires permissions for the elasticfilesystem:TagResource action.

    Args:
        resource_id(str): The ID specifying the EFS resource that you want to create a tag for.
        tags(List): An array of Tag objects to add. Each Tag object is a key-value pair.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.resource.tag(ctx, resource_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.resource.tag resource_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="tag_resource",
        op_kwargs={"ResourceId": resource_id, "Tags": tags},
    )


async def untag(hub, ctx, resource_id: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API operation. This operation requires permissions for the elasticfilesystem:UntagResource action.

    Args:
        resource_id(str): Specifies the EFS resource that you want to remove tags from.
        tag_keys(List): The keys of the key-value tag pairs that you want to remove from the specified EFS resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.resource.untag(ctx, resource_id=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.resource.untag resource_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="untag_resource",
        op_kwargs={"ResourceId": resource_id, "TagKeys": tag_keys},
    )
