"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, mount_target_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the security groups currently in effect for a mount target. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not deleted. This operation requires permissions for the following actions:    elasticfilesystem:DescribeMountTargetSecurityGroups action on the mount target's file system.     ec2:DescribeNetworkInterfaceAttribute action on the mount target's network interface.

    Args:
        mount_target_id(str): The ID of the mount target whose security groups you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.mount_target.security_group.describe_all(
                ctx, mount_target_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.mount_target.security_group.describe_all mount_target_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_mount_target_security_groups",
        op_kwargs={"MountTargetId": mount_target_id},
    )


async def modify(hub, ctx, mount_target_id: str, security_groups: List = None) -> None:
    r"""
    **Autogenerated function**

    Modifies the set of security groups in effect for a mount target. When you create a mount target, Amazon EFS also creates a new network interface. For more information, see CreateMountTarget. This operation replaces the security groups in effect for the network interface associated with a mount target, with the SecurityGroups provided in the request. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not deleted.  The operation requires permissions for the following actions:    elasticfilesystem:ModifyMountTargetSecurityGroups action on the mount target's file system.     ec2:ModifyNetworkInterfaceAttribute action on the mount target's network interface.

    Args:
        mount_target_id(str): The ID of the mount target whose security groups you want to modify.
        security_groups(List, optional): An array of up to five VPC security group IDs. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.mount_target.security_group.modify(
                ctx, mount_target_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.mount_target.security_group.modify mount_target_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="modify_mount_target_security_groups",
        op_kwargs={"MountTargetId": mount_target_id, "SecurityGroups": security_groups},
    )
