"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, file_system_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current LifecycleConfiguration object for the specified Amazon EFS file system. EFS lifecycle management uses the LifecycleConfiguration object to identify which files to move to the EFS Infrequent Access (IA) storage class. For a file system without a LifecycleConfiguration object, the call returns an empty array in the response. This operation requires permissions for the elasticfilesystem:DescribeLifecycleConfiguration operation.

    Args:
        file_system_id(str): The ID of the file system whose LifecycleConfiguration object you want to retrieve (String).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.lifecycle_configuration.describe(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.lifecycle_configuration.describe file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_lifecycle_configuration",
        op_kwargs={"FileSystemId": file_system_id},
    )


async def put(hub, ctx, file_system_id: str, lifecycle_policies: List) -> Dict:
    r"""
    **Autogenerated function**

    Enables lifecycle management by creating a new LifecycleConfiguration object. A LifecycleConfiguration object defines when files in an Amazon EFS file system are automatically transitioned to the lower-cost EFS Infrequent Access (IA) storage class. A LifecycleConfiguration applies to all files in a file system. Each Amazon EFS file system supports one lifecycle configuration, which applies to all files in the file system. If a LifecycleConfiguration object already exists for the specified file system, a PutLifecycleConfiguration call modifies the existing configuration. A PutLifecycleConfiguration call with an empty LifecyclePolicies array in the request body deletes any existing LifecycleConfiguration and disables lifecycle management. In the request, specify the following:    The ID for the file system for which you are enabling, disabling, or modifying lifecycle management.   A LifecyclePolicies array of LifecyclePolicy objects that define when files are moved to the IA storage class. The array can contain only one LifecyclePolicy item.   This operation requires permissions for the elasticfilesystem:PutLifecycleConfiguration operation. To apply a LifecycleConfiguration object to an encrypted file system, you need the same AWS Key Management Service (AWS KMS) permissions as when you created the encrypted file system.

    Args:
        file_system_id(str): The ID of the file system for which you are creating the LifecycleConfiguration object (String).
        lifecycle_policies(List): An array of LifecyclePolicy objects that define the file system's LifecycleConfiguration object. A LifecycleConfiguration object tells lifecycle management when to transition files from the Standard storage class to the Infrequent Access storage class.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.lifecycle_configuration.put(
                ctx, file_system_id=value, lifecycle_policies=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.lifecycle_configuration.put file_system_id=value, lifecycle_policies=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="put_lifecycle_configuration",
        op_kwargs={
            "FileSystemId": file_system_id,
            "LifecyclePolicies": lifecycle_policies,
        },
    )
