"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, file_system_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the FileSystemPolicy for the specified file system. The default FileSystemPolicy goes into effect once the existing policy is deleted. For more information about the default file system policy, see Using Resource-based Policies with EFS. This operation requires permissions for the elasticfilesystem:DeleteFileSystemPolicy action.

    Args:
        file_system_id(str): Specifies the EFS file system for which to delete the FileSystemPolicy.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.file_system.policy.delete(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.file_system.policy.delete file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="delete_file_system_policy",
        op_kwargs={"FileSystemId": file_system_id},
    )


async def describe(hub, ctx, file_system_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the FileSystemPolicy for the specified EFS file system. This operation requires permissions for the elasticfilesystem:DescribeFileSystemPolicy action.

    Args:
        file_system_id(str): Specifies which EFS file system to retrieve the FileSystemPolicy for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.file_system.policy.describe(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.file_system.policy.describe file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_file_system_policy",
        op_kwargs={"FileSystemId": file_system_id},
    )


async def put(
    hub,
    ctx,
    file_system_id: str,
    policy: str,
    bypass_policy_lockout_safety_check: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Applies an Amazon EFS FileSystemPolicy to an Amazon EFS file system. A file system policy is an IAM resource-based policy and can contain multiple policy statements. A file system always has exactly one file system policy, which can be the default policy or an explicit policy set or updated using this API operation. EFS file system policies have a 20,000 character limit. When an explicit policy is set, it overrides the default policy. For more information about the default file system policy, see Default EFS File System Policy.  EFS file system policies have a 20,000 character limit. This operation requires permissions for the elasticfilesystem:PutFileSystemPolicy action.

    Args:
        file_system_id(str): The ID of the EFS file system that you want to create or update the FileSystemPolicy for.
        policy(str): The FileSystemPolicy that you're creating. Accepts a JSON formatted policy definition. EFS file system policies have a 20,000 character limit. To find out more about the elements that make up a file system policy, see EFS Resource-based Policies. .
        bypass_policy_lockout_safety_check(bool, optional): (Optional) A flag to indicate whether to bypass the FileSystemPolicy lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future PutFileSystemPolicy requests on the file system. Set BypassPolicyLockoutSafetyCheck to True only when you intend to prevent the principal that is making the request from making a subsequent PutFileSystemPolicy request on the file system. The default value is False. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.file_system.policy.put(
                ctx, file_system_id=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.file_system.policy.put file_system_id=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="put_file_system_policy",
        op_kwargs={
            "FileSystemId": file_system_id,
            "Policy": policy,
            "BypassPolicyLockoutSafetyCheck": bypass_policy_lockout_safety_check,
        },
    )
