"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    creation_token: str,
    performance_mode: str = None,
    encrypted: bool = None,
    kms_key_id: str = None,
    throughput_mode: str = None,
    provisioned_throughput_in_mibps: float = None,
    availability_zone_name: str = None,
    backup: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does not currently exist that is owned by the caller's AWS account with the specified creation token, this operation does the following:   Creates a new, empty file system. The file system will have an Amazon EFS assigned ID, and an initial lifecycle state creating.   Returns with the description of the created file system.   Otherwise, this operation returns a FileSystemAlreadyExists error with the ID of the existing file system.  For basic use cases, you can use a randomly generated UUID for the creation token.   The idempotent operation allows you to retry a CreateFileSystem call without risk of creating an extra file system. This can happen when an initial call fails in a way that leaves it uncertain whether or not a file system was actually created. An example might be that a transport level timeout occurred or your connection was reset. As long as you use the same creation token, if the initial call had succeeded in creating a file system, the client can learn of its existence from the FileSystemAlreadyExists error. For more information, see Creating a file system in the Amazon EFS User Guide.  The CreateFileSystem call returns while the file system's lifecycle state is still creating. You can check the file system creation status by calling the DescribeFileSystems operation, which among other things returns the file system state.  This operation accepts an optional PerformanceMode parameter that you choose for your file system. We recommend generalPurpose performance mode for most file systems. File systems using the maxIO performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created. For more information, see Amazon EFS performance modes. You can set the throughput mode for the file system using the ThroughputMode parameter. After the file system is fully created, Amazon EFS sets its lifecycle state to available, at which point you can create one or more mount targets for the file system in your VPC. For more information, see CreateMountTarget. You mount your Amazon EFS file system on an EC2 instances in your VPC by using the mount target. For more information, see Amazon EFS: How it Works.   This operation requires permissions for the elasticfilesystem:CreateFileSystem action.

    Args:
        creation_token(str): A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
        performance_mode(str, optional): The performance mode of the file system. We recommend generalPurpose performance mode for most file systems. File systems using the maxIO performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.  The maxIO mode is not supported on file systems using One Zone storage classes. . Defaults to None.
        encrypted(bool, optional): A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying CreateFileSystemRequest$KmsKeyId for an existing AWS Key Management Service (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the default CMK for Amazon EFS, /aws/elasticfilesystem, is used to protect the encrypted file system. . Defaults to None.
        kms_key_id(str, optional): The ID of the AWS KMS CMK that you want to use to protect the encrypted file system. This parameter is only required if you want to use a non-default KMS key. If this parameter is not specified, the default CMK for Amazon EFS is used. This ID can be in one of the following formats:   Key ID - A unique identifier of the key, for example 1234abcd-12ab-34cd-56ef-1234567890ab.   ARN - An Amazon Resource Name (ARN) for the key, for example arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias - A previously created display name for a key, for example alias/projectKey1.   Key alias ARN - An ARN for a key alias, for example arn:aws:kms:us-west-2:444455556666:alias/projectKey1.   If KmsKeyId is specified, the CreateFileSystemRequest$Encrypted parameter must be set to true.  EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with EFS file systems. . Defaults to None.
        throughput_mode(str, optional): Specifies the throughput mode for the file system, either bursting or provisioned. If you set ThroughputMode to provisioned, you must also set a value for ProvisionedThroughputInMibps. After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see Specifying throughput with provisioned mode in the Amazon EFS User Guide.  Default is bursting. Defaults to None.
        provisioned_throughput_in_mibps(float, optional): The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid values are 1-1024. Required if ThroughputMode is set to provisioned. The upper limit for throughput is 1024 MiB/s. To increase this limit, contact AWS Support. For more information, see Amazon EFS quotas that you can increase in the Amazon EFS User Guide. Defaults to None.
        availability_zone_name(str, optional): Used to create a file system that uses One Zone storage classes. It specifies the AWS Availability Zone in which to create the file system. Use the format us-east-1a to specify the Availability Zone. For more information about One Zone storage classes, see Using EFS storage classes in the Amazon EFS User Guide.  One Zone storage classes are not available in all Availability Zones in AWS Regions where Amazon EFS is available. . Defaults to None.
        backup(bool, optional): Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to true to enable automatic backups. If you are creating a file system that uses One Zone storage classes, automatic backups are enabled by default. For more information, see Automatic backups in the Amazon EFS User Guide. Default is false. However, if you specify an AvailabilityZoneName, the default is true.  AWS Backup is not available in all AWS Regions where Amazon EFS is available. . Defaults to None.
        tags(List, optional): A value that specifies to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a "Key":"Name","Value":"{value}" key-value pair. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.file_system.init.create(ctx, creation_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.file_system.init.create creation_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="create_file_system",
        op_kwargs={
            "CreationToken": creation_token,
            "PerformanceMode": performance_mode,
            "Encrypted": encrypted,
            "KmsKeyId": kms_key_id,
            "ThroughputMode": throughput_mode,
            "ProvisionedThroughputInMibps": provisioned_throughput_in_mibps,
            "AvailabilityZoneName": availability_zone_name,
            "Backup": backup,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, file_system_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists and you can't access any contents of the deleted file system.  You can't delete a file system that is in use. That is, if the file system has any mount targets, you must first delete them. For more information, see DescribeMountTargets and DeleteMountTarget.   The DeleteFileSystem call returns while the file system state is still deleting. You can check the file system deletion status by calling the DescribeFileSystems operation, which returns a list of file systems in your account. If you pass file system ID or creation token for the deleted file system, the DescribeFileSystems returns a 404 FileSystemNotFound error.  This operation requires permissions for the elasticfilesystem:DeleteFileSystem action.

    Args:
        file_system_id(str): The ID of the file system you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.file_system.init.delete(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.file_system.init.delete file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="delete_file_system",
        op_kwargs={"FileSystemId": file_system_id},
    )


async def describe_all(
    hub,
    ctx,
    max_items: int = None,
    marker: str = None,
    creation_token: str = None,
    file_system_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of a specific Amazon EFS file system if either the file system CreationToken or the FileSystemId is provided. Otherwise, it returns descriptions of all file systems owned by the caller's AWS account in the AWS Region of the endpoint that you're calling. When retrieving all file system descriptions, you can optionally specify the MaxItems parameter to limit the number of descriptions in a response. Currently, this number is automatically set to 10. If more file system descriptions remain, Amazon EFS returns a NextMarker, an opaque token, in the response. In this case, you should send a subsequent request with the Marker request parameter set to the value of NextMarker.  To retrieve a list of your file system descriptions, this operation is used in an iterative process, where DescribeFileSystems is called first without the Marker and then the operation continues to call it with the Marker parameter set to the value of the NextMarker from the previous response until the response has no NextMarker.   The order of file systems returned in the response of one DescribeFileSystems call and the order of file systems returned across the responses of a multi-call iteration is unspecified.   This operation requires permissions for the elasticfilesystem:DescribeFileSystems action.

    Args:
        max_items(int, optional): (Optional) Specifies the maximum number of file systems to return in the response (integer). This number is automatically set to 100. The response is paginated at 100 per page if you have more than 100 file systems. . Defaults to None.
        marker(str, optional): (Optional) Opaque pagination token returned from a previous DescribeFileSystems operation (String). If present, specifies to continue the list from where the returning call had left off. . Defaults to None.
        creation_token(str, optional): (Optional) Restricts the list to the file system with this creation token (String). You specify a creation token when you create an Amazon EFS file system. Defaults to None.
        file_system_id(str, optional): (Optional) ID of the file system whose description you want to retrieve (String). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.file_system.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.file_system.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_file_systems",
        op_kwargs={
            "MaxItems": max_items,
            "Marker": marker,
            "CreationToken": creation_token,
            "FileSystemId": file_system_id,
        },
    )


async def update(
    hub,
    ctx,
    file_system_id: str,
    throughput_mode: str = None,
    provisioned_throughput_in_mibps: float = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the throughput mode or the amount of provisioned throughput of an existing file system.

    Args:
        file_system_id(str): The ID of the file system that you want to update.
        throughput_mode(str, optional): (Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the ThroughputMode to provisioned, you must also set a value for ProvisionedThroughputInMibps. Defaults to None.
        provisioned_throughput_in_mibps(float, optional): (Optional) Sets the amount of provisioned throughput, in MiB/s, for the file system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also provide the amount of provisioned throughput. Required if ThroughputMode is changed to provisioned on update. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.file_system.init.update(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.file_system.init.update file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="update_file_system",
        op_kwargs={
            "FileSystemId": file_system_id,
            "ThroughputMode": throughput_mode,
            "ProvisionedThroughputInMibps": provisioned_throughput_in_mibps,
        },
    )
