"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, file_system_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the backup policy for the specified EFS file system.

    Args:
        file_system_id(str): Specifies which EFS file system to retrieve the BackupPolicy for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.backup_policy.describe(ctx, file_system_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.backup_policy.describe file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_backup_policy",
        op_kwargs={"FileSystemId": file_system_id},
    )


async def put(hub, ctx, file_system_id: str, backup_policy: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system.

    Args:
        file_system_id(str): Specifies which EFS file system to update the backup policy for.
        backup_policy(Dict): The backup policy included in the PutBackupPolicy request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.backup_policy.put(
                ctx, file_system_id=value, backup_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.backup_policy.put file_system_id=value, backup_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="put_backup_policy",
        op_kwargs={"FileSystemId": file_system_id, "BackupPolicy": backup_policy},
    )
