"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        next_token(str, optional): Token used for pagination. Defaults to None.
        max_results(int, optional): Max results used for pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.account_preference.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.account_preference.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_account_preferences",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def put_multiple(hub, ctx, resource_id_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        resource_id_type(str): A preference indicating a choice to use 63bit/32bit IDs for all applicable resources.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.account_preference.put_multiple(ctx, resource_id_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.account_preference.put_multiple resource_id_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="put_account_preferences",
        op_kwargs={"ResourceIdType": resource_id_type},
    )
