"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_token: str,
    file_system_id: str,
    tags: List = None,
    posix_user: Dict = None,
    root_directory: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point. The operating system user and group override any identity information provided by the NFS client. The file system path is exposed as the access point's root directory. Applications using the access point can only access data in its own directory and below. To learn more, see Mounting a file system using EFS access points. This operation requires permissions for the elasticfilesystem:CreateAccessPoint action.

    Args:
        client_token(str): A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.
        tags(List, optional): Creates tags associated with the access point. Each tag is a key-value pair. Defaults to None.
        file_system_id(str): The ID of the EFS file system that the access point provides access to.
        posix_user(Dict, optional): The operating system user and group applied to all file system requests made using the access point. Defaults to None.
        root_directory(Dict, optional): Specifies the directory on the Amazon EFS file system that the access point exposes as the root directory of your file system to NFS clients using the access point. The clients using the access point can only access the root directory and below. If the RootDirectory > Path specified does not exist, EFS creates it and applies the CreationInfo settings when a client connects to an access point. When specifying a RootDirectory, you need to provide the Path, and the CreationInfo. Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount using the access point will fail. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.access_point.create(
                ctx, client_token=value, file_system_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.access_point.create client_token=value, file_system_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="create_access_point",
        op_kwargs={
            "ClientToken": client_token,
            "Tags": tags,
            "FileSystemId": file_system_id,
            "PosixUser": posix_user,
            "RootDirectory": root_directory,
        },
    )


async def delete(hub, ctx, access_point_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified access point. After deletion is complete, new clients can no longer connect to the access points. Clients connected to the access point at the time of deletion will continue to function until they terminate their connection. This operation requires permissions for the elasticfilesystem:DeleteAccessPoint action.

    Args:
        access_point_id(str): The ID of the access point that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.access_point.delete(ctx, access_point_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.access_point.delete access_point_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="delete_access_point",
        op_kwargs={"AccessPointId": access_point_id},
    )


async def describe_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    access_point_id: str = None,
    file_system_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of a specific Amazon EFS access point if the AccessPointId is provided. If you provide an EFS FileSystemId, it returns descriptions of all access points for that file system. You can provide either an AccessPointId or a FileSystemId in the request, but not both.  This operation requires permissions for the elasticfilesystem:DescribeAccessPoints action.

    Args:
        max_results(int, optional): (Optional) When retrieving all access points for a file system, you can optionally specify the MaxItems parameter to limit the number of objects returned in a response. The default value is 100. . Defaults to None.
        next_token(str, optional):  NextToken is present if the response is paginated. You can use NextMarker in the subsequent request to fetch the next page of access point descriptions. Defaults to None.
        access_point_id(str, optional): (Optional) Specifies an EFS access point to describe in the response; mutually exclusive with FileSystemId. Defaults to None.
        file_system_id(str, optional): (Optional) If you provide a FileSystemId, EFS returns all access points for that file system; mutually exclusive with AccessPointId. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.efs.access_point.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.efs.access_point.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="efs",
        operation="describe_access_points",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "AccessPointId": access_point_id,
            "FileSystemId": file_system_id,
        },
    )
