"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def submit(
    hub,
    ctx,
    cluster: str = None,
    task: str = None,
    status: str = None,
    reason: str = None,
    containers: List = None,
    attachments: List = None,
    managed_agents: List = None,
    pull_started_at: str = None,
    pull_stopped_at: str = None,
    execution_stopped_at: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.  Sent to acknowledge that a task changed states.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task. Defaults to None.
        task(str, optional): The task ID or full ARN of the task in the state change request. Defaults to None.
        status(str, optional): The status of the state change request. Defaults to None.
        reason(str, optional): The reason for the state change request. Defaults to None.
        containers(List, optional): Any containers associated with the state change request. Defaults to None.
        attachments(List, optional): Any attachments associated with the state change request. Defaults to None.
        managed_agents(List, optional): The details for the managed agent associated with the task. Defaults to None.
        pull_started_at(str, optional): The Unix timestamp for when the container image pull began. Defaults to None.
        pull_stopped_at(str, optional): The Unix timestamp for when the container image pull completed. Defaults to None.
        execution_stopped_at(str, optional): The Unix timestamp for when the task execution stopped. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.state_change.submit(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.state_change.submit
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="submit_task_state_change",
        op_kwargs={
            "cluster": cluster,
            "task": task,
            "status": status,
            "reason": reason,
            "containers": containers,
            "attachments": attachments,
            "managedAgents": managed_agents,
            "pullStartedAt": pull_started_at,
            "pullStoppedAt": pull_stopped_at,
            "executionStoppedAt": execution_stopped_at,
        },
    )
