"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "set"


async def create(
    hub,
    ctx,
    service: str,
    cluster: str,
    task_definition: str,
    external_id: str = None,
    network_configuration: Dict = None,
    load_balancers: List = None,
    service_registries: List = None,
    launch_type: str = None,
    capacity_provider_strategy: List = None,
    platform_version: str = None,
    scale: Dict = None,
    client_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a task set in the specified cluster and service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see Amazon ECS Deployment Types in the Amazon Elastic Container Service Developer Guide.

    Args:
        service(str): The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        cluster(str): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        external_id(str, optional): An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the ECS_TASK_SET_EXTERNAL_ID Cloud Map attribute set to the provided value. Defaults to None.
        task_definition(str): The task definition for the tasks in the task set to use.
        network_configuration(Dict, optional): An object representing the network configuration for a task set. Defaults to None.
        load_balancers(List, optional): A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer. Defaults to None.
        service_registries(List, optional): The details of the service discovery registries to assign to this task set. For more information, see Service Discovery. Defaults to None.
        launch_type(str, optional): The launch type that new tasks in the task set will use. For more information, see Amazon ECS Launch Types in the Amazon Elastic Container Service Developer Guide. If a launchType is specified, the capacityProviderStrategy parameter must be omitted. Defaults to None.
        capacity_provider_strategy(List, optional): The capacity provider strategy to use for the task set. A capacity provider strategy consists of one or more capacity providers along with the base and weight to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an ACTIVE or UPDATING status can be used. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation. To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used. The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created. Defaults to None.
        platform_version(str, optional): The platform version that the tasks in the task set should use. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the LATEST platform version is used by default. Defaults to None.
        scale(Dict, optional): A floating-point percentage of the desired number of tasks to place and keep running in the task set. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 32 ASCII characters are allowed. Defaults to None.
        tags(List, optional): The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8   Maximum value length - 256 Unicode characters in UTF-8   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case-sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.set_.create(
                ctx, service=value, cluster=value, task_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.set.create service=value, cluster=value, task_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="create_task_set",
        op_kwargs={
            "service": service,
            "cluster": cluster,
            "externalId": external_id,
            "taskDefinition": task_definition,
            "networkConfiguration": network_configuration,
            "loadBalancers": load_balancers,
            "serviceRegistries": service_registries,
            "launchType": launch_type,
            "capacityProviderStrategy": capacity_provider_strategy,
            "platformVersion": platform_version,
            "scale": scale,
            "clientToken": client_token,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, cluster: str, service: str, task_set: str, force: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified task set within a service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see Amazon ECS Deployment Types in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set exists in to delete.
        service(str): The short name or full Amazon Resource Name (ARN) of the service that hosts the task set to delete.
        task_set(str): The task set ID or full Amazon Resource Name (ARN) of the task set to delete.
        force(bool, optional): If true, this allows you to delete a task set even if it hasn't been scaled down to zero. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.set_.delete(
                ctx, cluster=value, service=value, task_set=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.set.delete cluster=value, service=value, task_set=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="delete_task_set",
        op_kwargs={
            "cluster": cluster,
            "service": service,
            "taskSet": task_set,
            "force": force,
        },
    )


async def describe_all(
    hub, ctx, cluster: str, service: str, task_sets: List = None, include: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the task sets in the specified cluster and service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see Amazon ECS Deployment Types in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task sets exist in.
        service(str): The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.
        task_sets(List, optional): The ID or full Amazon Resource Name (ARN) of task sets to describe. Defaults to None.
        include(List, optional): Specifies whether to see the resource tags for the task set. If TAGS is specified, the tags are included in the response. If this field is omitted, tags are not included in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.set_.describe_all(ctx, cluster=value, service=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.set.describe_all cluster=value, service=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="describe_task_sets",
        op_kwargs={
            "cluster": cluster,
            "service": service,
            "taskSets": task_sets,
            "include": include,
        },
    )


async def update(
    hub, ctx, cluster: str, service: str, task_set: str, scale: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a task set. This is used when a service uses the EXTERNAL deployment controller type. For more information, see Amazon ECS Deployment Types in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set exists in.
        service(str): The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.
        task_set(str): The short name or full Amazon Resource Name (ARN) of the task set to update.
        scale(Dict): A floating-point percentage of the desired number of tasks to place and keep running in the task set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.set_.update(
                ctx, cluster=value, service=value, task_set=value, scale=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.set.update cluster=value, service=value, task_set=value, scale=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="update_task_set",
        op_kwargs={
            "cluster": cluster,
            "service": service,
            "taskSet": task_set,
            "scale": scale,
        },
    )
