"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, tasks: List, cluster: str = None, include: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a specified task or tasks.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task or tasks to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the task or tasks you are describing were launched in any cluster other than the default cluster. Defaults to None.
        tasks(List): A list of up to 100 task IDs or full ARN entries.
        include(List, optional): Specifies whether you want to see the resource tags for the task. If TAGS is specified, the tags are included in the response. If this field is omitted, tags are not included in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.init.describe_all(ctx, tasks=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.init.describe_all tasks=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="describe_tasks",
        op_kwargs={"cluster": cluster, "tasks": tasks, "include": include},
    )


async def list_all(
    hub,
    ctx,
    cluster: str = None,
    container_instance: str = None,
    family: str = None,
    next_token: str = None,
    max_results: int = None,
    started_by: str = None,
    service_name: str = None,
    desired_status: str = None,
    launch_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of tasks. You can filter the results by cluster, task definition family, container instance, launch type, what IAM principal started the task, or by the desired status of the task. Recently stopped tasks might appear in the returned results. Currently, stopped tasks appear in the returned results for at least one hour.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the ListTasks results. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        container_instance(str, optional): The container instance ID or full ARN of the container instance to use when filtering the ListTasks results. Specifying a containerInstance limits the results to tasks that belong to that container instance. Defaults to None.
        family(str, optional): The name of the task definition family to use when filtering the ListTasks results. Specifying a family limits the results to tasks that belong to that family. Defaults to None.
        next_token(str, optional): The nextToken value returned from a ListTasks request indicating that more results are available to fulfill the request and further calls will be needed. If maxResults was provided, it is possible the number of results to be fewer than maxResults.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): The maximum number of task results returned by ListTasks in paginated output. When this parameter is used, ListTasks only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListTasks request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListTasks returns up to 100 results and a nextToken value if applicable. Defaults to None.
        started_by(str, optional): The startedBy value with which to filter the task results. Specifying a startedBy value limits the results to tasks that were started with that value. Defaults to None.
        service_name(str, optional): The name of the service to use when filtering the ListTasks results. Specifying a serviceName limits the results to tasks that belong to that service. Defaults to None.
        desired_status(str, optional): The task desired status to use when filtering the ListTasks results. Specifying a desiredStatus of STOPPED limits the results to tasks that Amazon ECS has set the desired status to STOPPED. This can be useful for debugging tasks that are not starting properly or have died or finished. The default status filter is RUNNING, which shows tasks that Amazon ECS has set the desired status to RUNNING.  Although you can filter results based on a desired status of PENDING, this does not return any results. Amazon ECS never sets the desired status of a task to that value (only a task's lastStatus may have a value of PENDING). . Defaults to None.
        launch_type(str, optional): The launch type to use when filtering the ListTasks results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="list_tasks",
        op_kwargs={
            "cluster": cluster,
            "containerInstance": container_instance,
            "family": family,
            "nextToken": next_token,
            "maxResults": max_results,
            "startedBy": started_by,
            "serviceName": service_name,
            "desiredStatus": desired_status,
            "launchType": launch_type,
        },
    )


async def run(
    hub,
    ctx,
    task_definition: str,
    capacity_provider_strategy: List = None,
    cluster: str = None,
    count: int = None,
    enable_ecs_managed_tags: bool = None,
    enable_execute_command: bool = None,
    group: str = None,
    launch_type: str = None,
    network_configuration: Dict = None,
    overrides: Dict = None,
    placement_constraints: List = None,
    placement_strategy: List = None,
    platform_version: str = None,
    propagate_tags: str = None,
    reference_id: str = None,
    started_by: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a new task using the specified task definition. You can allow Amazon ECS to place tasks for you, or you can customize how Amazon ECS places tasks using placement constraints and placement strategies. For more information, see Scheduling Tasks in the Amazon Elastic Container Service Developer Guide. Alternatively, you can use StartTask to use your own scheduler or place tasks manually on specific container instances. The Amazon ECS API follows an eventual consistency model, due to the distributed nature of the system supporting the API. This means that the result of an API command you run that affects your Amazon ECS resources might not be immediately visible to all subsequent commands you run. Keep this in mind when you carry out an API command that immediately follows a previous API command. To manage eventual consistency, you can do the following:   Confirm the state of the resource before you run a command to modify it. Run the DescribeTasks command using an exponential backoff algorithm to ensure that you allow enough time for the previous command to propagate through the system. To do this, run the DescribeTasks command repeatedly, starting with a couple of seconds of wait time and increasing gradually up to five minutes of wait time.   Add wait time between subsequent commands, even if the DescribeTasks command returns an accurate response. Apply an exponential backoff algorithm starting with a couple of seconds of wait time, and increase gradually up to about five minutes of wait time.

    Args:
        capacity_provider_strategy(List, optional): The capacity provider strategy to use for the task. If a capacityProviderStrategy is specified, the launchType parameter must be omitted. If no capacityProviderStrategy or launchType is specified, the defaultCapacityProviderStrategy for the cluster is used. When you use cluster auto scaling, you must specify capacityProviderStrategy and not launchType. . Defaults to None.
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster on which to run your task. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        count(int, optional): The number of instantiations of the specified task to place on your cluster. You can specify up to 10 tasks per call. Defaults to None.
        enable_ecs_managed_tags(bool, optional): Specifies whether to enable Amazon ECS managed tags for the task. For more information, see Tagging Your Amazon ECS Resources in the Amazon Elastic Container Service Developer Guide. Defaults to None.
        enable_execute_command(bool, optional): Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task. Defaults to None.
        group(str, optional): The name of the task group to associate with the task. The default value is the family name of the task definition (for example, family:my-family-name). Defaults to None.
        launch_type(str, optional): The infrastructure on which to run your standalone task. For more information, see Amazon ECS launch types in the Amazon Elastic Container Service Developer Guide. The FARGATE launch type runs your tasks on Fargate On-Demand infrastructure.  Fargate Spot infrastructure is available for use but a capacity provider strategy must be used. For more information, see Fargate capacity providers in the Amazon ECS User Guide for Fargate.  The EC2 launch type runs your tasks on Amazon EC2 instances registered to your cluster. The EXTERNAL launch type runs your tasks on your on-premise server or virtual machine (VM) capacity registered to your cluster. A task can use either a launch type or a capacity provider strategy. If a launchType is specified, the capacityProviderStrategy parameter must be omitted. When you use cluster auto scaling, you must specify capacityProviderStrategy and not launchType. . Defaults to None.
        network_configuration(Dict, optional): The network configuration for the task. This parameter is required for task definitions that use the awsvpc network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see Task Networking in the Amazon Elastic Container Service Developer Guide. Defaults to None.
        overrides(Dict, optional): A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it should receive. You can override the default command for a container (that is specified in the task definition or Docker image) with a command override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an environment override.  A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure. . Defaults to None.
        placement_constraints(List, optional): An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). Defaults to None.
        placement_strategy(List, optional): The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. Defaults to None.
        platform_version(str, optional): The platform version the task should run. A platform version is only specified for tasks using the Fargate launch type. If one is not specified, the LATEST platform version is used by default. For more information, see Fargate Platform Versions in the Amazon Elastic Container Service Developer Guide. Defaults to None.
        propagate_tags(str, optional): Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.  An error will be received if you specify the SERVICE option when running a task. . Defaults to None.
        reference_id(str, optional): The reference ID to use for the task. Defaults to None.
        started_by(str, optional): An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the startedBy parameter. You can then identify which tasks belong to that job by filtering the results of a ListTasks call with the startedBy value. Up to 36 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed. If a task is started by an Amazon ECS service, then the startedBy parameter contains the deployment ID of the service that starts it. Defaults to None.
        tags(List, optional): The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8   Maximum value length - 256 Unicode characters in UTF-8   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case-sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.  . Defaults to None.
        task_definition(str): The family and revision (family:revision) or full ARN of the task definition to run. If a revision is not specified, the latest ACTIVE revision is used.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.init.run(ctx, task_definition=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.init.run task_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="run_task",
        op_kwargs={
            "capacityProviderStrategy": capacity_provider_strategy,
            "cluster": cluster,
            "count": count,
            "enableECSManagedTags": enable_ecs_managed_tags,
            "enableExecuteCommand": enable_execute_command,
            "group": group,
            "launchType": launch_type,
            "networkConfiguration": network_configuration,
            "overrides": overrides,
            "placementConstraints": placement_constraints,
            "placementStrategy": placement_strategy,
            "platformVersion": platform_version,
            "propagateTags": propagate_tags,
            "referenceId": reference_id,
            "startedBy": started_by,
            "tags": tags,
            "taskDefinition": task_definition,
        },
    )


async def start(
    hub,
    ctx,
    container_instances: List,
    task_definition: str,
    cluster: str = None,
    enable_ecs_managed_tags: bool = None,
    enable_execute_command: bool = None,
    group: str = None,
    network_configuration: Dict = None,
    overrides: Dict = None,
    propagate_tags: str = None,
    reference_id: str = None,
    started_by: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a new task from the specified task definition on the specified container instance or instances. Alternatively, you can use RunTask to place tasks for you. For more information, see Scheduling Tasks in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster on which to start your task. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        container_instances(List): The container instance IDs or full ARN entries for the container instances on which you would like to place your task. You can specify up to 10 container instances.
        enable_ecs_managed_tags(bool, optional): Specifies whether to enable Amazon ECS managed tags for the task. For more information, see Tagging Your Amazon ECS Resources in the Amazon Elastic Container Service Developer Guide. Defaults to None.
        enable_execute_command(bool, optional): Whether or not the execute command functionality is enabled for the task. If true, this enables execute command functionality on all containers in the task. Defaults to None.
        group(str, optional): The name of the task group to associate with the task. The default value is the family name of the task definition (for example, family:my-family-name). Defaults to None.
        network_configuration(Dict, optional): The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the awsvpc networking mode. Defaults to None.
        overrides(Dict, optional): A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it should receive. You can override the default command for a container (that is specified in the task definition or Docker image) with a command override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an environment override.  A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure. . Defaults to None.
        propagate_tags(str, optional): Specifies whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags are not propagated. Defaults to None.
        reference_id(str, optional): The reference ID to use for the task. Defaults to None.
        started_by(str, optional): An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the startedBy parameter. You can then identify which tasks belong to that job by filtering the results of a ListTasks call with the startedBy value. Up to 36 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed. If a task is started by an Amazon ECS service, then the startedBy parameter contains the deployment ID of the service that starts it. Defaults to None.
        tags(List, optional): The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8   Maximum value length - 256 Unicode characters in UTF-8   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case-sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.  . Defaults to None.
        task_definition(str): The family and revision (family:revision) or full ARN of the task definition to start. If a revision is not specified, the latest ACTIVE revision is used.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.init.start(
                ctx, container_instances=value, task_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.init.start container_instances=value, task_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="start_task",
        op_kwargs={
            "cluster": cluster,
            "containerInstances": container_instances,
            "enableECSManagedTags": enable_ecs_managed_tags,
            "enableExecuteCommand": enable_execute_command,
            "group": group,
            "networkConfiguration": network_configuration,
            "overrides": overrides,
            "propagateTags": propagate_tags,
            "referenceId": reference_id,
            "startedBy": started_by,
            "tags": tags,
            "taskDefinition": task_definition,
        },
    )


async def stop(hub, ctx, task: str, cluster: str = None, reason: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Stops a running task. Any tags associated with the task will be deleted. When StopTask is called on a task, the equivalent of docker stop is issued to the containers running in the task. This results in a SIGTERM value and a default 30-second timeout, after which the SIGKILL value is sent and the containers are forcibly stopped. If the container handles the SIGTERM value gracefully and exits within 30 seconds from receiving it, no SIGKILL value is sent.  The default 30-second timeout can be configured on the Amazon ECS container agent with the ECS_CONTAINER_STOP_TIMEOUT variable. For more information, see Amazon ECS Container Agent Configuration in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        task(str): The task ID or full Amazon Resource Name (ARN) of the task to stop.
        reason(str, optional): An optional message specified when a task is stopped. For example, if you are using a custom scheduler, you can use this parameter to specify the reason for stopping the task here, and the message appears in subsequent DescribeTasks API operations on this task. Up to 255 characters are allowed in this message. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.task.init.stop(ctx, task=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.task.init.stop task=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="stop_task",
        op_kwargs={"cluster": cluster, "task": task, "reason": reason},
    )
