"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "primary_task_set"


async def update(hub, ctx, cluster: str, service: str, primary_task_set: str) -> Dict:
    r"""
    **Autogenerated function**

    Modifies which task set in a service is the primary task set. Any parameters that are updated on the primary task set in a service will transition to the service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see Amazon ECS Deployment Types in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set exists in.
        service(str): The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.
        primary_task_set(str): The short name or full Amazon Resource Name (ARN) of the task set to set as the primary task set in the deployment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.service.primary_task_set_.update(
                ctx, cluster=value, service=value, primary_task_set=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.service.primary_task_set.update cluster=value, service=value, primary_task_set=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="update_service_primary_task_set",
        op_kwargs={
            "cluster": cluster,
            "service": service,
            "primaryTaskSet": primary_task_set,
        },
    )
