"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def discover(
    hub, ctx, container_instance: str = None, cluster: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.  Returns an endpoint for the Amazon ECS agent to poll for updates.

    Args:
        container_instance(str, optional): The container instance ID or full ARN of the container instance. The ARN contains the arn:aws:ecs namespace, followed by the Region of the container instance, the account ID of the container instance owner, the container-instance namespace, and then the container instance ID. For example, arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID. Defaults to None.
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster to which the container instance belongs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.poll_endpoint.discover(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.poll_endpoint.discover
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="discover_poll_endpoint",
        op_kwargs={"containerInstance": container_instance, "cluster": cluster},
    )
