"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def submit(
    hub,
    ctx,
    cluster: str = None,
    task: str = None,
    container_name: str = None,
    runtime_id: str = None,
    status: str = None,
    exit_code: int = None,
    reason: str = None,
    network_bindings: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.  Sent to acknowledge that a container changed states.

    Args:
        cluster(str, optional): The short name or full ARN of the cluster that hosts the container. Defaults to None.
        task(str, optional): The task ID or full Amazon Resource Name (ARN) of the task that hosts the container. Defaults to None.
        container_name(str, optional): The name of the container. Defaults to None.
        runtime_id(str, optional): The ID of the Docker container. Defaults to None.
        status(str, optional): The status of the state change request. Defaults to None.
        exit_code(int, optional): The exit code returned for the state change request. Defaults to None.
        reason(str, optional): The reason for the state change request. Defaults to None.
        network_bindings(List, optional): The network bindings of the container. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.container.state_change.submit(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.container.state_change.submit
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="submit_container_state_change",
        op_kwargs={
            "cluster": cluster,
            "task": task,
            "containerName": container_name,
            "runtimeId": runtime_id,
            "status": status,
            "exitCode": exit_code,
            "reason": reason,
            "networkBindings": network_bindings,
        },
    )
