"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(
    hub, ctx, container_instance: str, cluster: str = None, force: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to run tasks. If you intend to use the container instance for some other purpose after deregistration, you should stop all of the tasks running on the container instance before deregistration. That prevents any orphaned tasks from consuming resources. Deregistering a container instance removes the instance from a cluster, but it does not terminate the EC2 instance. If you are finished using the instance, be sure to terminate it in the Amazon EC2 console to stop billing.  If you terminate a running container instance, Amazon ECS automatically deregisters the instance from your cluster (stopped container instances or instances with disconnected agents are not automatically deregistered when terminated).

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instance to deregister. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        container_instance(str): The container instance ID or full ARN of the container instance to deregister. The ARN contains the arn:aws:ecs namespace, followed by the Region of the container instance, the account ID of the container instance owner, the container-instance namespace, and then the container instance ID. For example, arn:aws:ecs:region:aws_account_id:container-instance/container_instance_ID.
        force(bool, optional): Forces the deregistration of the container instance. If you have tasks running on the container instance when you deregister it with the force option, these tasks remain running until you terminate the instance or the tasks stop through some other means, but they are orphaned (no longer monitored or accounted for by Amazon ECS). If an orphaned task on your container instance is part of an Amazon ECS service, then the service scheduler starts another copy of that task, on a different container instance if possible.  Any containers in orphaned service tasks that are registered with a Classic Load Balancer or an Application Load Balancer target group are deregistered. They begin connection draining according to the settings on the load balancer or target group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.container.instance.init.deregister(
                ctx, container_instance=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.container.instance.init.deregister container_instance=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="deregister_container_instance",
        op_kwargs={
            "cluster": cluster,
            "containerInstance": container_instance,
            "force": force,
        },
    )


async def describe_all(
    hub, ctx, container_instances: List, cluster: str = None, include: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more container instances. Returns metadata about each container instance requested.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container instance or container instances you are describing were launched in any cluster other than the default cluster. Defaults to None.
        container_instances(List): A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
        include(List, optional): Specifies whether you want to see the resource tags for the container instance. If TAGS is specified, the tags are included in the response. If this field is omitted, tags are not included in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.container.instance.init.describe_all(
                ctx, container_instances=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.container.instance.init.describe_all container_instances=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="describe_container_instances",
        op_kwargs={
            "cluster": cluster,
            "containerInstances": container_instances,
            "include": include,
        },
    )


async def list_all(
    hub,
    ctx,
    cluster: str = None,
    filter_: str = None,
    next_token: str = None,
    max_results: int = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of container instances in a specified cluster. You can filter the results of a ListContainerInstances operation with cluster query language statements inside the filter parameter. For more information, see Cluster Query Language in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        filter_(str, optional): You can filter the results of a ListContainerInstances operation with cluster query language statements. For more information, see Cluster Query Language in the Amazon Elastic Container Service Developer Guide. Defaults to None.
        next_token(str, optional): The nextToken value returned from a ListContainerInstances request indicating that more results are available to fulfill the request and further calls will be needed. If maxResults was provided, it is possible the number of results to be fewer than maxResults.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): The maximum number of container instance results returned by ListContainerInstances in paginated output. When this parameter is used, ListContainerInstances only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListContainerInstances request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListContainerInstances returns up to 100 results and a nextToken value if applicable. Defaults to None.
        status(str, optional): Filters the container instances by status. For example, if you specify the DRAINING status, the results include only container instances that have been set to DRAINING using UpdateContainerInstancesState. If you do not specify this parameter, the default is to include container instances set to all states other than INACTIVE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.container.instance.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.container.instance.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="list_container_instances",
        op_kwargs={
            "cluster": cluster,
            "filter": filter_,
            "nextToken": next_token,
            "maxResults": max_results,
            "status": status,
        },
    )


async def register(
    hub,
    ctx,
    cluster: str = None,
    instance_identity_document: str = None,
    instance_identity_document_signature: str = None,
    total_resources: List = None,
    version_info: Dict = None,
    container_instance_arn: str = None,
    attributes: List = None,
    platform_devices: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.  Registers an EC2 instance into the specified cluster. This instance becomes available to place containers on.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster with which to register your container instance. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        instance_identity_document(str, optional): The instance identity document for the EC2 instance to register. This document can be found by running the following command from the instance: curl http://169.254.169.254/latest/dynamic/instance-identity/document/ . Defaults to None.
        instance_identity_document_signature(str, optional): The instance identity document signature for the EC2 instance to register. This signature can be found by running the following command from the instance: curl http://169.254.169.254/latest/dynamic/instance-identity/signature/ . Defaults to None.
        total_resources(List, optional): The resources available on the instance. Defaults to None.
        version_info(Dict, optional): The version information for the Amazon ECS container agent and Docker daemon running on the container instance. Defaults to None.
        container_instance_arn(str, optional): The ARN of the container instance (if it was previously registered). Defaults to None.
        attributes(List, optional): The container instance attributes that this container instance supports. Defaults to None.
        platform_devices(List, optional): The devices that are available on the container instance. The only supported device type is a GPU. Defaults to None.
        tags(List, optional): The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8   Maximum value length - 256 Unicode characters in UTF-8   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case-sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.container.instance.init.register(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.container.instance.init.register
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="register_container_instance",
        op_kwargs={
            "cluster": cluster,
            "instanceIdentityDocument": instance_identity_document,
            "instanceIdentityDocumentSignature": instance_identity_document_signature,
            "totalResources": total_resources,
            "versionInfo": version_info,
            "containerInstanceArn": container_instance_arn,
            "attributes": attributes,
            "platformDevices": platform_devices,
            "tags": tags,
        },
    )
