"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, container_instance: str, cluster: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Amazon ECS container agent on a specified container instance. Updating the Amazon ECS container agent does not interrupt running tasks or services on the container instance. The process for updating the agent differs depending on whether your container instance was launched with the Amazon ECS-optimized AMI or another operating system.  The UpdateContainerAgent API isn't supported for container instances using the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI. To update the container agent, you can update the ecs-init package which will update the agent. For more information, see Updating the Amazon ECS container agent in the Amazon Elastic Container Service Developer Guide.  The UpdateContainerAgent API requires an Amazon ECS-optimized AMI or Amazon Linux AMI with the ecs-init service installed and running. For help updating the Amazon ECS container agent on other operating systems, see Manually updating the Amazon ECS container agent in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that your container instance is running on. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        container_instance(str): The container instance ID or full ARN entries for the container instance on which you would like to update the Amazon ECS container agent.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.container.agent.update(ctx, container_instance=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.container.agent.update container_instance=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="update_container_agent",
        op_kwargs={"cluster": cluster, "containerInstance": container_instance},
    )
