"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def execute(
    hub,
    ctx,
    command: str,
    interactive: bool,
    task: str,
    cluster: str = None,
    container: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs a command remotely on a container within a task.

    Args:
        cluster(str, optional): The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        container(str, optional): The name of the container to execute the command on. A container name only needs to be specified for tasks containing multiple containers. Defaults to None.
        command(str): The command to run on the container.
        interactive(bool): Use this flag to run your command in interactive mode.
        task(str): The Amazon Resource Name (ARN) or ID of the task the container is part of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.command.execute(
                ctx, command=value, interactive=value, task=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.command.execute command=value, interactive=value, task=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="execute_command",
        op_kwargs={
            "cluster": cluster,
            "container": container,
            "command": command,
            "interactive": interactive,
            "task": task,
        },
    )
