"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cluster_name: str = None,
    tags: List = None,
    settings: List = None,
    configuration: Dict = None,
    capacity_providers: List = None,
    default_capacity_provider_strategy: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon ECS cluster. By default, your account receives a default cluster when you launch your first container instance. However, you can create your own cluster with a unique name with the CreateCluster action.  When you call the CreateCluster API operation, Amazon ECS attempts to create the Amazon ECS service-linked role for your account so that required resources in other Amazon Web Services services can be managed on your behalf. However, if the IAM user that makes the call does not have permissions to create the service-linked role, it is not created. For more information, see Using Service-Linked Roles for Amazon ECS in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster_name(str, optional): The name of your cluster. If you do not specify a name for your cluster, you create a cluster named default. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. . Defaults to None.
        tags(List, optional): The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8   Maximum value length - 256 Unicode characters in UTF-8   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case-sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.  . Defaults to None.
        settings(List, optional): The setting to use when creating a cluster. This parameter is used to enable CloudWatch Container Insights for a cluster. If this value is specified, it will override the containerInsights value set with PutAccountSetting or PutAccountSettingDefault. Defaults to None.
        configuration(Dict, optional): The execute command configuration for the cluster. Defaults to None.
        capacity_providers(List, optional): The short name of one or more capacity providers to associate with the cluster. A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy when calling the CreateService or RunTask actions. If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created and not already associated with another cluster. New Auto Scaling group capacity providers can be created with the CreateCapacityProvider API operation. To use a Fargate capacity provider, specify either the FARGATE or FARGATE_SPOT capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used. The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created. Defaults to None.
        default_capacity_provider_strategy(List, optional): The capacity provider strategy to set as the default for the cluster. When a default capacity provider strategy is set for a cluster, when calling the RunTask or CreateService APIs wtih no capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster is used. If a default capacity provider strategy is not defined for a cluster during creation, it can be defined later with the PutClusterCapacityProviders API operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.cluster.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.cluster.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="create_cluster",
        op_kwargs={
            "clusterName": cluster_name,
            "tags": tags,
            "settings": settings,
            "configuration": configuration,
            "capacityProviders": capacity_providers,
            "defaultCapacityProviderStrategy": default_capacity_provider_strategy,
        },
    )


async def delete(hub, ctx, cluster: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified cluster. The cluster will transition to the INACTIVE state. Clusters with an INACTIVE status may remain discoverable in your account for a period of time. However, this behavior is subject to change in the future, so you should not rely on INACTIVE clusters persisting. You must deregister all container instances from this cluster before you may delete it. You can list the container instances in a cluster with ListContainerInstances and deregister them with DeregisterContainerInstance.

    Args:
        cluster(str): The short name or full Amazon Resource Name (ARN) of the cluster to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.cluster.init.delete(ctx, cluster=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.cluster.init.delete cluster=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="delete_cluster",
        op_kwargs={"cluster": cluster},
    )


async def describe_all(hub, ctx, clusters: List = None, include: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your clusters.

    Args:
        clusters(List, optional): A list of up to 100 cluster names or full cluster Amazon Resource Name (ARN) entries. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        include(List, optional): Whether to include additional information about the clusters in the response. If this field is omitted, this information isn't included. If ATTACHMENTS is specified, the attachments for the container instances or tasks within the cluster are included. If SETTINGS is specified, the settings for the cluster are included. If STATISTICS is specified, the task and service count is included, separated by launch type. If TAGS is specified, the metadata tags associated with the cluster are included. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.cluster.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.cluster.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="describe_clusters",
        op_kwargs={"clusters": clusters, "include": include},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing clusters.

    Args:
        next_token(str, optional): The nextToken value returned from a ListClusters request indicating that more results are available to fulfill the request and further calls will be needed. If maxResults was provided, it is possible the number of results to be fewer than maxResults.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): The maximum number of cluster results returned by ListClusters in paginated output. When this parameter is used, ListClusters only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListClusters request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListClusters returns up to 100 results and a nextToken value if applicable. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.cluster.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.cluster.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="list_clusters",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub, ctx, cluster: str, settings: List = None, configuration: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the cluster.

    Args:
        cluster(str): The name of the cluster to modify the settings for.
        settings(List, optional): The cluster settings for your cluster. Defaults to None.
        configuration(Dict, optional): The execute command configuration for the cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.cluster.init.update(ctx, cluster=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.cluster.init.update cluster=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="update_cluster",
        op_kwargs={
            "cluster": cluster,
            "settings": settings,
            "configuration": configuration,
        },
    )
