"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, auto_scaling_group_provider: Dict, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling. Only capacity providers using an Auto Scaling group can be created. Amazon ECS tasks on Fargate use the FARGATE and FARGATE_SPOT capacity providers which are already created and available to all accounts in Regions supported by Fargate.

    Args:
        name(str): The name of the capacity provider. Up to 255 characters are allowed, including letters (upper and lowercase), numbers, underscores, and hyphens. The name cannot be prefixed with "aws", "ecs", or "fargate".
        auto_scaling_group_provider(Dict): The details of the Auto Scaling group for the capacity provider.
        tags(List, optional): The metadata that you apply to the capacity provider to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. The following basic restrictions apply to tags:   Maximum number of tags per resource - 50   For each resource, each tag key must be unique, and each tag key can have only one value.   Maximum key length - 128 Unicode characters in UTF-8   Maximum value length - 256 Unicode characters in UTF-8   If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.   Tag keys and values are case-sensitive.   Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.capacity_provider.create(
                ctx, name=value, auto_scaling_group_provider=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.capacity_provider.create name=value, auto_scaling_group_provider=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="create_capacity_provider",
        op_kwargs={
            "name": name,
            "autoScalingGroupProvider": auto_scaling_group_provider,
            "tags": tags,
        },
    )


async def delete(hub, ctx, capacity_provider: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified capacity provider.  The FARGATE and FARGATE_SPOT capacity providers are reserved and cannot be deleted. You can disassociate them from a cluster using either the PutClusterCapacityProviders API or by deleting the cluster.  Prior to a capacity provider being deleted, the capacity provider must be removed from the capacity provider strategy from all services. The UpdateService API can be used to remove a capacity provider from a service's capacity provider strategy. When updating a service, the forceNewDeployment option can be used to ensure that any tasks using the Amazon EC2 instance capacity provided by the capacity provider are transitioned to use the capacity from the remaining capacity providers. Only capacity providers that are not associated with a cluster can be deleted. To remove a capacity provider from a cluster, you can either use PutClusterCapacityProviders or delete the cluster.

    Args:
        capacity_provider(str): The short name or full Amazon Resource Name (ARN) of the capacity provider to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.capacity_provider.delete(ctx, capacity_provider=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.capacity_provider.delete capacity_provider=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="delete_capacity_provider",
        op_kwargs={"capacityProvider": capacity_provider},
    )


async def describe_all(
    hub,
    ctx,
    capacity_providers: List = None,
    include: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your capacity providers.

    Args:
        capacity_providers(List, optional): The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to 100 capacity providers can be described in an action. Defaults to None.
        include(List, optional): Specifies whether or not you want to see the resource tags for the capacity provider. If TAGS is specified, the tags are included in the response. If this field is omitted, tags are not included in the response. Defaults to None.
        max_results(int, optional): The maximum number of account setting results returned by DescribeCapacityProviders in paginated output. When this parameter is used, DescribeCapacityProviders only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeCapacityProviders request with the returned nextToken value. This value can be between 1 and 10. If this parameter is not used, then DescribeCapacityProviders returns up to 10 results and a nextToken value if applicable. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeCapacityProviders request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.capacity_provider.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.capacity_provider.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="describe_capacity_providers",
        op_kwargs={
            "capacityProviders": capacity_providers,
            "include": include,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(hub, ctx, name: str, auto_scaling_group_provider: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the parameters for a capacity provider.

    Args:
        name(str): The name of the capacity provider to update.
        auto_scaling_group_provider(Dict): An object representing the parameters to update for the Auto Scaling group capacity provider.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.capacity_provider.update(
                ctx, name=value, auto_scaling_group_provider=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.capacity_provider.update name=value, auto_scaling_group_provider=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="update_capacity_provider",
        op_kwargs={
            "name": name,
            "autoScalingGroupProvider": auto_scaling_group_provider,
        },
    )
