"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, attributes: List, cluster: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more custom attributes from an Amazon ECS resource.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to delete attributes. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        attributes(List): The attributes to delete from your resource. You can specify up to 10 attributes per request. For custom attributes, specify the attribute name and target ID, but do not specify the value. If you specify the target ID using the short form, you must also specify the target type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.attribute.delete_multiple(ctx, attributes=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.attribute.delete_multiple attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="delete_attributes",
        op_kwargs={"cluster": cluster, "attributes": attributes},
    )


async def list_all(
    hub,
    ctx,
    target_type: str,
    cluster: str = None,
    attribute_name: str = None,
    attribute_value: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the attributes for Amazon ECS resources within a specified target type and cluster. When you specify a target type and cluster, ListAttributes returns a list of attribute objects, one for each attribute on each resource. You can filter the list of results to a single attribute name to only return results that have that name. You can also filter the results by attribute name and value, for example, to see which container instances in a cluster are running a Linux AMI (ecs.os-type=linux).

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster to list attributes. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        target_type(str): The type of the target with which to list attributes.
        attribute_name(str, optional): The name of the attribute with which to filter the results. . Defaults to None.
        attribute_value(str, optional): The value of the attribute with which to filter results. You must also specify an attribute name to use this parameter. Defaults to None.
        next_token(str, optional): The nextToken value returned from a ListAttributes request indicating that more results are available to fulfill the request and further calls will be needed. If maxResults was provided, it is possible the number of results to be fewer than maxResults.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): The maximum number of cluster results returned by ListAttributes in paginated output. When this parameter is used, ListAttributes only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListAttributes request with the returned nextToken value. This value can be between 1 and 100. If this parameter is not used, then ListAttributes returns up to 100 results and a nextToken value if applicable. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.attribute.list_all(ctx, target_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.attribute.list_all target_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="list_attributes",
        op_kwargs={
            "cluster": cluster,
            "targetType": target_type,
            "attributeName": attribute_name,
            "attributeValue": attribute_value,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def put_multiple(hub, ctx, attributes: List, cluster: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Create or update an attribute on an Amazon ECS resource. If the attribute does not exist, it is created. If the attribute exists, its value is replaced with the specified value. To delete an attribute, use DeleteAttributes. For more information, see Attributes in the Amazon Elastic Container Service Developer Guide.

    Args:
        cluster(str, optional): The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply attributes. If you do not specify a cluster, the default cluster is assumed. Defaults to None.
        attributes(List): The attributes to apply to your resource. You can specify up to 10 custom attributes per resource. You can specify up to 10 attributes in a single call.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.attribute.put_multiple(ctx, attributes=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.attribute.put_multiple attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="put_attributes",
        op_kwargs={"cluster": cluster, "attributes": attributes},
    )
