"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def submit(hub, ctx, attachments: List, cluster: str = None) -> Dict:
    r"""
    **Autogenerated function**

     This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.  Sent to acknowledge that an attachment changed states.

    Args:
        cluster(str, optional): The short name or full ARN of the cluster that hosts the container instance the attachment belongs to. Defaults to None.
        attachments(List): Any attachments associated with the state change request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.attachment_state_change.submit(ctx, attachments=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.attachment_state_change.submit attachments=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="submit_attachment_state_changes",
        op_kwargs={"cluster": cluster, "attachments": attachments},
    )
