"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(hub, ctx, name: str, value: str) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an account setting for all IAM users on an account for whom no individual account setting has been specified. Account settings are set on a per-Region basis.

    Args:
        name(str): The resource name for which to modify the account setting. If serviceLongArnFormat is specified, the ARN for your Amazon ECS services is affected. If taskLongArnFormat is specified, the ARN and resource ID for your Amazon ECS tasks is affected. If containerInstanceLongArnFormat is specified, the ARN and resource ID for your Amazon ECS container instances is affected. If awsvpcTrunking is specified, the ENI limit for your Amazon ECS container instances is affected. If containerInsights is specified, the default setting for CloudWatch Container Insights for your clusters is affected.
        value(str): The account setting value for the specified principal ARN. Accepted values are enabled and disabled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecs.account_setting.default.put(ctx, name=value, value=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecs.account_setting.default.put name=value, value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecs",
        operation="put_account_setting_default",
        op_kwargs={"name": name, "value": value},
    )
