"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, repository_name: str, registry_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve catalog metadata for a repository in a public registry. This metadata is displayed publicly in the Amazon ECR Public Gallery.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repositories to be described. If you do not specify a registry, the default public registry is assumed. Defaults to None.
        repository_name(str): The name of the repository to retrieve the catalog metadata for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.repository.catalog_data.get(
                ctx, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.repository.catalog_data.get repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="get_repository_catalog_data",
        op_kwargs={"registryId": registry_id, "repositoryName": repository_name},
    )


async def put(
    hub, ctx, repository_name: str, catalog_data: Dict, registry_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the catalog data for a repository in a public registry.

    Args:
        registry_id(str, optional): The AWS account ID associated with the public registry the repository is in. If you do not specify a registry, the default public registry is assumed. Defaults to None.
        repository_name(str): The name of the repository to create or update the catalog data for.
        catalog_data(Dict): An object containing the catalog data for a repository. This data is publicly visible in the Amazon ECR Public Gallery.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.repository.catalog_data.put(
                ctx, repository_name=value, catalog_data=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.repository.catalog_data.put repository_name=value, catalog_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="put_repository_catalog_data",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "catalogData": catalog_data,
        },
    )
