"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns details for a public registry.

    Args:
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeRegistries request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): The maximum number of repository results returned by DescribeRegistries in paginated output. When this parameter is used, DescribeRegistries only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeRegistries request with the returned nextToken value. This value can be between 1 and 1000. If this parameter is not used, then DescribeRegistries returns up to 100 results and a nextToken value, if applicable. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.registry.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.registry.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="describe_registries",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
