"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves catalog metadata for a public registry.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.registry.catalog_data.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.registry.catalog_data.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="get_registry_catalog_data",
        op_kwargs={},
    )


async def put(hub, ctx, display_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Create or updates the catalog data for a public registry.

    Args:
        display_name(str, optional): The display name for a public registry. The display name is shown as the repository author in the Amazon ECR Public Gallery.  The registry display name is only publicly visible in the Amazon ECR Public Gallery for verified accounts. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.registry.catalog_data.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.registry.catalog_data.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="put_registry_catalog_data",
        op_kwargs={"displayName": display_name},
    )
