"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def complete(
    hub,
    ctx,
    repository_name: str,
    upload_id: str,
    layer_digests: List,
    registry_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Informs Amazon ECR that the image layer upload has completed for a specified public registry, repository name, and upload ID. You can optionally provide a sha256 digest of the image layer for data validation purposes. When an image is pushed, the CompleteLayerUpload API is called once per each new image layer to verify that the upload has completed.  This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and push images.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry to which to upload layers. If you do not specify a registry, the default public registry is assumed. Defaults to None.
        repository_name(str): The name of the repository in a public registry to associate with the image layer.
        upload_id(str): The upload ID from a previous InitiateLayerUpload operation to associate with the image layer.
        layer_digests(List): The sha256 digest of the image layer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.layer.upload.complete(
                ctx, repository_name=value, upload_id=value, layer_digests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.layer.upload.complete repository_name=value, upload_id=value, layer_digests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="complete_layer_upload",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "uploadId": upload_id,
            "layerDigests": layer_digests,
        },
    )


async def initiate(hub, ctx, repository_name: str, registry_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Notifies Amazon ECR that you intend to upload an image layer. When an image is pushed, the InitiateLayerUpload API is called once per image layer that has not already been uploaded. Whether or not an image layer has been uploaded is determined by the BatchCheckLayerAvailability API action.  This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and push images.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry to which you intend to upload layers. If you do not specify a registry, the default public registry is assumed. Defaults to None.
        repository_name(str): The name of the repository to which you intend to upload layers.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.layer.upload.initiate(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.layer.upload.initiate repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="initiate_layer_upload",
        op_kwargs={"registryId": registry_id, "repositoryName": repository_name},
    )
