"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    repository_name: str,
    registry_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the image tag details for a repository in a public registry.

    Args:
        registry_id(str, optional): The AWS account ID associated with the public registry that contains the repository in which to describe images. If you do not specify a registry, the default public registry is assumed. Defaults to None.
        repository_name(str): The name of the repository that contains the image tag details to describe.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeImageTags request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return. This option cannot be used when you specify images with imageIds. Defaults to None.
        max_results(int, optional): The maximum number of repository results returned by DescribeImageTags in paginated output. When this parameter is used, DescribeImageTags only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeImageTags request with the returned nextToken value. This value can be between 1 and 1000. If this parameter is not used, then DescribeImageTags returns up to 100 results and a nextToken value, if applicable. This option cannot be used when you specify images with imageIds. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.image.tag.describe_all(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.image.tag.describe_all repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="describe_image_tags",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
