"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours. This API requires the ecr-public:GetAuthorizationToken and sts:GetServiceBearerToken permissions.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr_public.authorization_token.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr_public.authorization_token.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr-public",
        operation="get_authorization_token",
        op_kwargs={},
    )
