"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def delete(hub, ctx, repository_name: str, registry_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the repository policy associated with the specified repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository policy to delete. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository that is associated with the repository policy to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.repository.policy.delete(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.repository.policy.delete repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="delete_repository_policy",
        op_kwargs={"registryId": registry_id, "repositoryName": repository_name},
    )


async def get(hub, ctx, repository_name: str, registry_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the repository policy for the specified repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository with the policy to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.repository.policy.get(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.repository.policy.get repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="get_repository_policy",
        op_kwargs={"registryId": registry_id, "repositoryName": repository_name},
    )


async def set_(
    hub,
    ctx,
    repository_name: str,
    policy_text: str,
    registry_id: str = None,
    force: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Applies a repository policy to the specified repository to control access permissions. For more information, see Amazon ECR Repository Policies in the Amazon Elastic Container Registry User Guide.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository to receive the policy.
        policy_text(str): The JSON repository policy text to apply to the repository. For more information, see Amazon ECR Repository Policies in the Amazon Elastic Container Registry User Guide.
        force(bool, optional): If the policy you are attempting to set on a repository policy would prevent you from setting another policy in the future, you must force the SetRepositoryPolicy operation. This is intended to prevent accidental repository lock outs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.repository.policy.set(
                ctx, repository_name=value, policy_text=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.repository.policy.set repository_name=value, policy_text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="set_repository_policy",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "policyText": policy_text,
            "force": force,
        },
    )
