"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    repository_name: str,
    tags: List = None,
    image_tag_mutability: str = None,
    image_scanning_configuration: Dict = None,
    encryption_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a repository. For more information, see Amazon ECR Repositories in the Amazon Elastic Container Registry User Guide.

    Args:
        repository_name(str): The name to use for the repository. The repository name may be specified on its own (such as nginx-web-app) or it can be prepended with a namespace to group the repository into a category (such as project-a/nginx-web-app).
        tags(List, optional): The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters. Defaults to None.
        image_tag_mutability(str, optional): The tag mutability setting for the repository. If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten. If IMMUTABLE is specified, all image tags within the repository will be immutable which will prevent them from being overwritten. Defaults to None.
        image_scanning_configuration(Dict, optional): The image scanning configuration for the repository. This determines whether images are scanned for known vulnerabilities after being pushed to the repository. Defaults to None.
        encryption_configuration(Dict, optional): The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.repository.init.create(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.repository.init.create repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="create_repository",
        op_kwargs={
            "repositoryName": repository_name,
            "tags": tags,
            "imageTagMutability": image_tag_mutability,
            "imageScanningConfiguration": image_scanning_configuration,
            "encryptionConfiguration": encryption_configuration,
        },
    )


async def delete(
    hub, ctx, repository_name: str, registry_id: str = None, force: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a repository. If the repository contains images, you must either delete all images in the repository or use the force option to delete the repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository to delete. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository to delete.
        force(bool, optional):  If a repository contains images, forces the deletion. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.repository.init.delete(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.repository.init.delete repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="delete_repository",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "force": force,
        },
    )


async def describe_all(
    hub,
    ctx,
    registry_id: str = None,
    repository_names: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes image repositories in a registry.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repositories to be described. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_names(List, optional): A list of repositories to describe. If this parameter is omitted, then all repositories in a registry are described. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeRepositories request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return. This option cannot be used when you specify repositories with repositoryNames.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): The maximum number of repository results returned by DescribeRepositories in paginated output. When this parameter is used, DescribeRepositories only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeRepositories request with the returned nextToken value. This value can be between 1 and 1000. If this parameter is not used, then DescribeRepositories returns up to 100 results and a nextToken value, if applicable. This option cannot be used when you specify repositories with repositoryNames. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.repository.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.repository.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="describe_repositories",
        op_kwargs={
            "registryId": registry_id,
            "repositoryNames": repository_names,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
