"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(hub, ctx, replication_configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the replication configuration for a registry. The existing replication configuration for a repository can be retrieved with the DescribeRegistry API action. The first time the PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the replication process. For more information, see Using Service-Linked Roles for Amazon ECR in the Amazon Elastic Container Registry User Guide.  When configuring cross-account replication, the destination account must grant the source account permission to replicate. This permission is controlled using a registry permissions policy. For more information, see PutRegistryPolicy.

    Args:
        replication_configuration(Dict): An object representing the replication configuration for a registry.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.replication_configuration.put(
                ctx, replication_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.replication_configuration.put replication_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="put_replication_configuration",
        op_kwargs={"replicationConfiguration": replication_configuration},
    )
