"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the registry permissions policy.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.registry.policy.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.registry.policy.delete
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ecr", operation="delete_registry_policy", op_kwargs={}
    )


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the permissions policy for a registry.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.registry.policy.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.registry.policy.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ecr", operation="get_registry_policy", op_kwargs={}
    )


async def put(hub, ctx, policy_text: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the permissions policy for your registry. A registry policy is used to specify permissions for another AWS account and is used when configuring cross-account replication. For more information, see Registry permissions in the Amazon Elastic Container Registry User Guide.

    Args:
        policy_text(str): The JSON policy text to apply to your registry. The policy text follows the same format as IAM policy text. For more information, see Registry permissions in the Amazon Elastic Container Registry User Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.registry.policy.put(ctx, policy_text=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.registry.policy.put policy_text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="put_registry_policy",
        op_kwargs={"policyText": policy_text},
    )
