"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    repository_name: str,
    registry_id: str = None,
    image_ids: List = None,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
) -> Dict:
    r"""
       **Autogenerated function**

       Retrieves the results of the lifecycle policy preview request for the specified repository.

       Args:
           registry_id(str, optional): The AWS account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed. Defaults to None.
           repository_name(str): The name of the repository.
           image_ids(List, optional): The list of imageIDs to be included. Defaults to None.
           next_token(str, optional): The nextToken value returned from a previous paginated
    GetLifecyclePolicyPreviewRequest request where maxResults was used and the
    results exceeded the value of that parameter. Pagination continues from the end of the
    previous results that returned the nextToken value. This value is
    null when there are no more results to return. This option cannot be used when you specify images with imageIds. Defaults to None.
           max_results(int, optional): The maximum number of repository results returned by GetLifecyclePolicyPreviewRequest in
    paginated output. When this parameter is used, GetLifecyclePolicyPreviewRequest only returns
    maxResults results in a single page along with a nextToken
    response element. The remaining results of the initial request can be seen by sending
    another GetLifecyclePolicyPreviewRequest request with the returned nextToken
    value. This value can be between 1 and 1000. If this
    parameter is not used, then GetLifecyclePolicyPreviewRequest returns up to
    100 results and a nextToken value, if
    applicable. This option cannot be used when you specify images with imageIds. Defaults to None.
           filter_(Dict, optional): An optional parameter that filters results based on image tag status and all tags, if tagged. Defaults to None.

       Returns:
           Dict

       Examples:
           Call from code:

           .. code-block:: python

               await hub.exec.aws_auto.ecr.lifecycle_policy.preview.get(ctx, repository_name=value)

           Call from CLI:

           .. code-block:: bash

               $ idem exec aws_auto.ecr.lifecycle_policy.preview.get repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="get_lifecycle_policy_preview",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageIds": image_ids,
            "nextToken": next_token,
            "maxResults": max_results,
            "filter": filter_,
        },
    )


async def start(
    hub,
    ctx,
    repository_name: str,
    registry_id: str = None,
    lifecycle_policy_text: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before associating the lifecycle policy with the repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository to be evaluated.
        lifecycle_policy_text(str, optional): The policy to be evaluated against. If you do not specify a policy, the current policy for the repository is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.lifecycle_policy.preview.start(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.lifecycle_policy.preview.start repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="start_lifecycle_policy_preview",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "lifecyclePolicyText": lifecycle_policy_text,
        },
    )
