"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, repository_name: str, registry_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the lifecycle policy associated with the specified repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.lifecycle_policy.init.delete(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.lifecycle_policy.init.delete repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="delete_lifecycle_policy",
        op_kwargs={"registryId": registry_id, "repositoryName": repository_name},
    )


async def get(hub, ctx, repository_name: str, registry_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the lifecycle policy for the specified repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.lifecycle_policy.init.get(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.lifecycle_policy.init.get repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="get_lifecycle_policy",
        op_kwargs={"registryId": registry_id, "repositoryName": repository_name},
    )


async def put(
    hub, ctx, repository_name: str, lifecycle_policy_text: str, registry_id: str = None
) -> Dict:
    r"""
       **Autogenerated function**

       Creates or updates the lifecycle policy for the specified repository. For more information, see Lifecycle Policy Template.

       Args:
           registry_id(str, optional): The AWS account ID associated with the registry that contains the repository. If you do
    not specify a registry, the default registry is assumed. Defaults to None.
           repository_name(str): The name of the repository to receive the policy.
           lifecycle_policy_text(str): The JSON repository policy text to apply to the repository.

       Returns:
           Dict

       Examples:
           Call from code:

           .. code-block:: python

               await hub.exec.aws_auto.ecr.lifecycle_policy.init.put(
                   ctx, repository_name=value, lifecycle_policy_text=value
               )

           Call from CLI:

           .. code-block:: bash

               $ idem exec aws_auto.ecr.lifecycle_policy.init.put repository_name=value, lifecycle_policy_text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="put_lifecycle_policy",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "lifecyclePolicyText": lifecycle_policy_text,
        },
    )
