"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def upload(
    hub,
    ctx,
    repository_name: str,
    upload_id: str,
    part_first_byte: int,
    part_last_byte: int,
    layer_part_blob: bytes,
    registry_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads an image layer part to Amazon ECR. When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (or about 20MB). The UploadLayerPart API is called once per each new image layer part.  This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and push images.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry to which you are uploading layer parts. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository to which you are uploading layer parts.
        upload_id(str): The upload ID from a previous InitiateLayerUpload operation to associate with the layer part upload.
        part_first_byte(int): The position of the first byte of the layer part witin the overall image layer.
        part_last_byte(int): The position of the last byte of the layer part within the overall image layer.
        layer_part_blob(bytes): The base64-encoded layer part payload.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.layer.part.upload(
                ctx,
                repository_name=value,
                upload_id=value,
                part_first_byte=value,
                part_last_byte=value,
                layer_part_blob=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.layer.part.upload repository_name=value, upload_id=value, part_first_byte=value, part_last_byte=value, layer_part_blob=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="upload_layer_part",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "uploadId": upload_id,
            "partFirstByte": part_first_byte,
            "partLastByte": part_last_byte,
            "layerPartBlob": layer_part_blob,
        },
    )
