"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub, ctx, repository_name: str, image_tag_mutability: str, registry_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the image tag mutability settings for the specified repository. For more information, see Image Tag Mutability in the Amazon Elastic Container Registry User Guide.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository in which to update the image tag mutability settings. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository in which to update the image tag mutability settings.
        image_tag_mutability(str): The tag mutability setting for the repository. If MUTABLE is specified, image tags can be overwritten. If IMMUTABLE is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.image.tag_mutability.put(
                ctx, repository_name=value, image_tag_mutability=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.image.tag_mutability.put repository_name=value, image_tag_mutability=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="put_image_tag_mutability",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageTagMutability": image_tag_mutability,
        },
    )
