"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub,
    ctx,
    repository_name: str,
    image_scanning_configuration: Dict,
    registry_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the image scanning configuration for the specified repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository in which to update the image scanning configuration setting. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository in which to update the image scanning configuration setting.
        image_scanning_configuration(Dict): The image scanning configuration for the repository. This setting determines whether images are scanned for known vulnerabilities after being pushed to the repository.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.image.scanning_configuration.put(
                ctx, repository_name=value, image_scanning_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.image.scanning_configuration.put repository_name=value, image_scanning_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="put_image_scanning_configuration",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageScanningConfiguration": image_scanning_configuration,
        },
    )
