"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub, ctx, repository_name: str, image_id: Dict, registry_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an image vulnerability scan. An image scan can only be started once per day on an individual image. This limit includes if an image was scanned on initial push. For more information, see Image Scanning in the Amazon Elastic Container Registry User Guide.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository in which to start an image scan request. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository that contains the images to scan.
        image_id(Dict): An object with identifying information for an Amazon ECR image.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.image.scan.init.start(
                ctx, repository_name=value, image_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.image.scan.init.start repository_name=value, image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="start_image_scan",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageId": image_id,
        },
    )
