"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    repository_name: str,
    image_id: Dict,
    registry_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the scan findings for the specified image.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository in which to describe the image scan findings for. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The repository for the image for which to describe the scan findings.
        image_id(Dict): An object with identifying information for an Amazon ECR image.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeImageScanFindings request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return. Defaults to None.
        max_results(int, optional): The maximum number of image scan results returned by DescribeImageScanFindings in paginated output. When this parameter is used, DescribeImageScanFindings only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeImageScanFindings request with the returned nextToken value. This value can be between 1 and 1000. If this parameter is not used, then DescribeImageScanFindings returns up to 100 results and a nextToken value, if applicable. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.image.scan.finding.describe_all(
                ctx, repository_name=value, image_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.image.scan.finding.describe_all repository_name=value, image_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="describe_image_scan_findings",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageId": image_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
