"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    repository_name: str,
    registry_id: str = None,
    image_ids: List = None,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about the images in a repository.  Beginning with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker registry. The output of the docker images command shows the uncompressed image size, so it may return a larger image size than the image sizes returned by DescribeImages.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository in which to describe images. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The repository that contains the images to describe.
        image_ids(List, optional): The list of image IDs for the requested repository. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated DescribeImages request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return. This option cannot be used when you specify images with imageIds. Defaults to None.
        max_results(int, optional): The maximum number of repository results returned by DescribeImages in paginated output. When this parameter is used, DescribeImages only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another DescribeImages request with the returned nextToken value. This value can be between 1 and 1000. If this parameter is not used, then DescribeImages returns up to 100 results and a nextToken value, if applicable. This option cannot be used when you specify images with imageIds. Defaults to None.
        filter_(Dict, optional): The filter key and value with which to filter your DescribeImages results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.image.init.describe_all(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.image.init.describe_all repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="describe_images",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageIds": image_ids,
            "nextToken": next_token,
            "maxResults": max_results,
            "filter": filter_,
        },
    )


async def list_all(
    hub,
    ctx,
    repository_name: str,
    registry_id: str = None,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the image IDs for the specified repository. You can filter images based on whether or not they are tagged by using the tagStatus filter and specifying either TAGGED, UNTAGGED or ANY. For example, you can filter your results to return only UNTAGGED images and then pipe that result to a BatchDeleteImage operation to delete them. Or, you can filter your results to return only TAGGED images to list all of the tags in your repository.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository in which to list images. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The repository with image IDs to be listed.
        next_token(str, optional): The nextToken value returned from a previous paginated ListImages request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value. This value is null when there are no more results to return.  This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        max_results(int, optional): The maximum number of image results returned by ListImages in paginated output. When this parameter is used, ListImages only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListImages request with the returned nextToken value. This value can be between 1 and 1000. If this parameter is not used, then ListImages returns up to 100 results and a nextToken value, if applicable. Defaults to None.
        filter_(Dict, optional): The filter key and value with which to filter your ListImages results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.image.init.list_all(ctx, repository_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.image.init.list_all repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="list_images",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "nextToken": next_token,
            "maxResults": max_results,
            "filter": filter_,
        },
    )


async def put(
    hub,
    ctx,
    repository_name: str,
    image_manifest: str,
    registry_id: str = None,
    image_manifest_media_type: str = None,
    image_tag: str = None,
    image_digest: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the image manifest and tags associated with an image. When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or update the image manifest and the tags associated with the image.  This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and push images.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the repository in which to put the image. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository in which to put the image.
        image_manifest(str): The image manifest corresponding to the image to be uploaded.
        image_manifest_media_type(str, optional): The media type of the image manifest. If you push an image manifest that does not contain the mediaType field, you must specify the imageManifestMediaType in the request. Defaults to None.
        image_tag(str, optional): The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats. Defaults to None.
        image_digest(str, optional): The image digest of the image manifest corresponding to the image. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.image.init.put(
                ctx, repository_name=value, image_manifest=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.image.init.put repository_name=value, image_manifest=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="put_image",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageManifest": image_manifest,
            "imageManifestMediaType": image_manifest_media_type,
            "imageTag": image_tag,
            "imageDigest": image_digest,
        },
    )
