"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, repository_name: str, layer_digest: str, registry_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image layers that are referenced in an image. When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer that is not already cached.  This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and push images.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the image layer to download. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository that is associated with the image layer to download.
        layer_digest(str): The digest of the image layer to download.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.download_url_for_layer.get(
                ctx, repository_name=value, layer_digest=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.download_url_for_layer.get repository_name=value, layer_digest=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="get_download_url_for_layer",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "layerDigest": layer_digest,
        },
    )
