"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, repository_name: str, image_ids: List, registry_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a list of specified images within a repository. Images are specified with either an imageTag or imageDigest. You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag from an image, the image is deleted from your repository. You can completely delete an image (and all of its tags) by specifying the image's digest in your request.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the image to delete. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The repository that contains the image to delete.
        image_ids(List): A list of image ID references that correspond to images to delete. The format of the imageIds reference is imageTag=tag or imageDigest=digest.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.delete_image.batch(
                ctx, repository_name=value, image_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.delete_image.batch repository_name=value, image_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="batch_delete_image",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "imageIds": image_ids,
        },
    )
