"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, repository_name: str, layer_digests: List, registry_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Checks the availability of one or more image layers in a repository. When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If it has been uploaded, then the image layer is skipped.  This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and push images.

    Args:
        registry_id(str, optional): The AWS account ID associated with the registry that contains the image layers to check. If you do not specify a registry, the default registry is assumed. Defaults to None.
        repository_name(str): The name of the repository that is associated with the image layers to check.
        layer_digests(List): The digests of the image layers to check.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.check_layer_availability.batch(
                ctx, repository_name=value, layer_digests=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.check_layer_availability.batch repository_name=value, layer_digests=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="batch_check_layer_availability",
        op_kwargs={
            "registryId": registry_id,
            "repositoryName": repository_name,
            "layerDigests": layer_digests,
        },
    )
