"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, registry_ids: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours. The authorizationToken returned is a base64 encoded string that can be decoded and used in a docker login command to authenticate to a registry. The AWS CLI offers an get-login-password command that simplifies the login process. For more information, see Registry Authentication in the Amazon Elastic Container Registry User Guide.

    Args:
        registry_ids(List, optional): A list of AWS account IDs that are associated with the registries for which to get AuthorizationData objects. If you do not specify a registry, the default registry is assumed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ecr.authorization_token.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ecr.authorization_token.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ecr",
        operation="get_authorization_token",
        op_kwargs={"registryIds": registry_ids},
    )
